﻿using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.Helpers
{
    internal static class DasHelper
    {
        public static DasMessage ParseHeaders(HttpRequest request)
        {
            if (request != null)
            {
                return new DasMessage(
                    request.Headers["X-ConversationID"],
                    request.Headers["X-RoutingSenderID"],
                    request.Headers["X-RoutingReceiverIDs"],
                    request.Headers["X-TransactionID"]
                );
            }

            return new DasMessage();
        }

        public static object StatusCode201(string conversationId)
        {
            return StatusCode("201", $"SUCCESS: Request Processed: {conversationId}");
        }

        public static object StatusCode400(string conversationId, string receiverId)
        {
            const string msg = "Bad Request: The request cannot be fulfilled due to missing/invalid parameters - {0}, {1}";
            return StatusCode("400", string.Format(msg, conversationId, receiverId));
        }

        public static object StatusCode500(string conversationId)
        {
            const string msg = "Internal Server Error-The server encountered an unexpected condition which prevented it from fulfilling the request - {0}";
            return StatusCode("500", string.Format(msg, conversationId));
        }

        public static object StatusCode(string code, string message)
        {
            try
            {
                const string returnMessageFormat = "{{ \"code\":\"{0}\", \"message\":\"{1}.\" }}";
                string jsonString = string.Format(returnMessageFormat, code, message);
                return JsonConvert.DeserializeObject(jsonString);
            }
            catch (System.Exception)
            {
                // return null object if result cannot be formed
                return null;
            }
        }
    }
}